<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php echo $__env->yieldPushContent('head'); ?>
    <?php echo $__env->make('partials.gtags', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <title><?php echo $__env->yieldContent('title', 'Meypar USA'); ?></title>
    <?php $fav = asset('imagenes/favicons'); ?>

    <link rel="icon" href="<?php echo e($fav); ?>/favicon.ico" type="image/x-icon">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e($fav); ?>/favicon-96x96.png">
    <link rel="icon" type="image/svg+xml" href="<?php echo e($fav); ?>/favicon.svg">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e($fav); ?>/apple-touch-icon.png">

    <!-- Web App Manifest -->
    <link rel="manifest" href="<?php echo e($fav); ?>/site.webmanifest">
    <meta name="theme-color" content="#ffffff">

    <script src="https://www.google.com/recaptcha/api.js?hl=en" async defer></script>
    
    <?php if(app()->environment('production')): ?>
        <?php echo NoCaptcha::renderJs(app()->getLocale()); ?>

    <?php endif; ?>

    <!-- Scroll & Navigation behavior -->
    <script>
        history.scrollRestoration = 'manual';

        document.addEventListener('DOMContentLoaded', function() {
            if (document.documentElement.dataset.scrollLock === 'true') {
                window.scrollTo(0, 0);
            }
        }, {
            once: true
        });

        (function() {
            if (window.location.hash) {
                history.replaceState(null, null, ' ');
            }
            window.scrollTo(0, 0);
            const html = document.documentElement;
            html.style.scrollBehavior = 'auto';
            html.style.overflow = 'hidden';
            html.dataset.scrollLock = 'true';

            window.addEventListener('load', function() {
                requestAnimationFrame(function() {
                    html.style.scrollBehavior = '';
                    html.style.overflow = '';
                    delete html.dataset.scrollLock;
                    if (window.pageYOffset > 0) window.scrollTo(0, 0);
                });
            }, {
                once: true
            });
        })();
    </script>

    <!-- AOS & Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link href="<?php echo e(asset('css/layout.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('styles'); ?>

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-719629494"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'AW-719629494');
    </script>

    <!-- Eventos para conversiones -->

    <script>
        gtag('event', 'conversion', {
            'send_to': 'AW-719629494/gRtfCML79osCELbZktcC'
        });
    </script>
    <script>
        gtag('event', 'conversion', {
            'send_to': 'AW-719629494/BfxWCJXK-4sCELbZktcC'
        });
    </script>

</head>

<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(asset('imagenes/Meypar-Automated-Parking-Logo-MEYPAR-USA.png')); ?>" alt="Logo Meypar USA"
                    width="150" height="60" />
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto align-items-center">
                    <!-- SOLUTIONS -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="<?php echo e(route('home')); ?>#solutions" role="button"
                            data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
                            SOLUTIONS
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#parcs">Parking Access and Revenue
                                    Control Systems (PARCS)</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#apgy">Automatic Parking Guidance
                                    Systems</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#vpm">Via Parking Meter</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#apt">Automated Payment Station</a>
                            </li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#gab">Gates and Barriers</a></li>
                        </ul>
                    </li>

                    <!-- SECTORS -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="<?php echo e(route('home')); ?>#sectors" role="button"
                            data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
                            SECTORS
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#sm">Shopping Malls</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#pc">Power Centers</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#mxd">Mixed-Use Developments</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#hosp">Hospitals</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#airpt">Airports</a></li>
                        </ul>
                    </li>

                    <!-- PRODUCTS -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="<?php echo e(route('home')); ?>#products" role="button"
                            data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
                            PRODUCTS
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#ecs">Entrance Control Station
                                    EVO</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#eps">Exit Payment Station EVO</a>
                            </li>
                            <li><a class="dropdown-item" href="<?php echo e(route('home')); ?>#ddg">Direct Drive Gate</a></li>
                        </ul>
                    </li>
                </ul>

                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item me-2 d-none d-lg-block">
                        <a class="nav-link" href="#" title="Search" id="searchTrigger">
                            <i class="bi bi-search" style="font-size: 1.2rem;"></i>
                        </a>
                    </li>
                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('home')); ?>#about-us">ABOUT US</a></li>
                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('home')); ?>#contact">CONTACT</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="container-fluid px-0"><?php echo $__env->yieldContent('content'); ?></main>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container">
            <div class="row">
                <!-- Contact -->
                <div class="col-md-4 mb-4 mb-md-0">
                    <h5 class="text-primary mb-3">CONTACT US</h5>
                    <div class="mb-3">
                        <h6 class="text-light mb-2">Call us:</h6>
                        <p class="mb-1">+1 (346) 220-4619 (Sales)</p>
                    </div>
                    <div>
                        <h6 class="text-light mb-2">Find us at:</h6>
                        <p>21755 I45, Building 11, Suite D - Spring, Texas 77388</p>
                    </div>
                </div>

                <!-- Reports -->
                <div class="col-md-4 mb-4 mb-md-0">
                    <h5 class="text-primary mb-3">REPORTS</h5>
                    <a href="https://report.eyspsa.com/" target="_blank" class="btn btn-outline-light">
                        MEYPAR USA Reports
                    </a>
                </div>

                <!-- Logo -->
                <div class="col-md-4 text-md-end">
                    <div class="mb-3">
                        <img src="<?php echo e(asset('imagenes/Meypar-Automated-Parking-Logo-MEYPAR-USA-1.png')); ?>"
                            alt="Logo Meypar USA White" width="150" class="img-fluid mb-2">
                    </div>
                    <p class="mb-0">&copy; <?php echo e(date('Y')); ?> MEYPAR USA. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Search Overlay -->
    <div id="searchOverlay" class="search-overlay">
        <div class="search-box">
            <input type="text" id="siteSearch" placeholder="Search..." autocomplete="off">
            <button id="closeSearch" aria-label="Close search">✕</button>
        </div>
    </div>

    <!-- JS Dependencies -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Navigation Scroll & Collapse on mobile - MEJORADO -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const navbar = document.getElementById('navbarNav');
            const toggler = document.querySelector('.navbar-toggler');

            // Inicializar collapse de Bootstrap
            const bsCollapse = new bootstrap.Collapse(navbar, {
                toggle: false
            });

            // Función para cerrar el menú
            const closeMenu = () => {
                if (window.innerWidth < 992) {
                    bsCollapse.hide();
                }
            };

            // Cerrar menú al hacer clic en enlaces de navegación
            document.querySelectorAll('.nav-link:not(.dropdown-toggle), .dropdown-item').forEach(item => {
                item.addEventListener('click', () => {
                    // Pequeño retraso para permitir la navegación
                    setTimeout(closeMenu, 100);
                });
            });

            // Cerrar menú al hacer clic fuera de él
            document.addEventListener('click', (e) => {
                if (window.innerWidth < 992 && navbar.classList.contains('show')) {
                    const isClickInsideNavbar = e.target.closest('.navbar');
                    const isClickOnToggler = e.target.closest('.navbar-toggler');

                    if (!isClickInsideNavbar && !isClickOnToggler) {
                        closeMenu();
                    }
                }
            });

            // Cerrar menú al hacer scroll en móvil
            let scrollTimeout;
            window.addEventListener('scroll', () => {
                if (window.innerWidth < 992 && navbar.classList.contains('show')) {
                    clearTimeout(scrollTimeout);
                    scrollTimeout = setTimeout(closeMenu, 150);
                }
            });

            // Smooth scroll para enlaces con hash
            document.querySelectorAll('a.nav-link[href^="#"]').forEach(link => {
                link.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (href !== '#' && href !== '') {
                        e.preventDefault();
                        const target = document.getElementById(href.substring(1));
                        if (target) {
                            const offset = target.getBoundingClientRect().top + window.pageYOffset -
                                document.querySelector('.navbar').offsetHeight;
                            window.scrollTo({
                                top: offset,
                                behavior: 'smooth'
                            });
                            closeMenu();
                        }
                    }
                });
            });
        });
    </script>
    <!-- SMS Link Handling -->
    <script>
        // Función para manejar el clic en botones SMS
        function handleSMSButtonClick(event) {
            // Prevenir el comportamiento por defecto del enlace
            event.preventDefault();

            // Obtener el número de teléfono y mensaje de los atributos data
            const phone = this.getAttribute('data-phone');
            const message = this.getAttribute('data-message');

            // Detectar si es un dispositivo móvil
            const isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);

            if (isMobile) {
                // Codificar el mensaje para URL
                const encodedMessage = encodeURIComponent(message);

                // Detectar si es iOS
                const isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent);

                // Crear la URL según el dispositivo
                let smsUrl;
                if (isIOS) {
                    // Formato para iOS: usa &body=
                    smsUrl = `sms:${phone}&body=${encodedMessage}`;
                } else {
                    // Formato para Android: usa ?body=
                    smsUrl = `sms:${phone}?body=${encodedMessage}`;
                }

                // Redirigir a la aplicación de mensajes
                window.location.href = smsUrl;
            } else {
                // Para dispositivos de escritorio: redirigir a la sección de contacto
                const contactSection = document.querySelector('#contact');
                if (contactSection) {
                    contactSection.scrollIntoView({
                        behavior: 'smooth'
                    });
                } else {
                    // Si no existe la sección, redirigir a página de contacto
                    window.location.href = "/contact";
                }
            }
        }

        // Inicializar todos los botones SMS después de cargar la página
        document.addEventListener('DOMContentLoaded', function() {
            // Seleccionar todos los botones con la clase sms-link (incluyendo los que tienen múltiples clases)
            const smsButtons = document.querySelectorAll('.sms-link');

            // Añadir el evento click a cada botón
            smsButtons.forEach(button => {
                button.addEventListener('click', handleSMSButtonClick);
            });
        });
    </script>

    <!-- Search functionality -->
    <script>
        const overlay = document.getElementById('searchOverlay');
        const closeBtn = document.getElementById('closeSearch');
        const input = document.getElementById('siteSearch');
        const trigger = document.getElementById('searchTrigger');

        if (trigger) trigger.addEventListener('click', e => {
            e.preventDefault();
            overlay.style.display = 'flex';
            input.value = '';
            input.focus();
        });

        closeBtn.addEventListener('click', () => overlay.style.display = 'none');

        document.addEventListener('keydown', e => {
            if (e.key === 'Escape') overlay.style.display = 'none';
        });

        input.addEventListener('keydown', e => {
            if (e.key === 'Enter' && input.value.trim()) {
                const searchTerm = input.value.trim().toLowerCase();
                let found = false;

                document.querySelectorAll('.search-highlight').forEach(el => el.classList.remove(
                    'search-highlight'));

                const elements = document.querySelectorAll('h1, h2, h3, h4, h5, h6, p, a, li, .searchable');
                for (const el of elements) {
                    if (el.textContent.toLowerCase().includes(searchTerm)) {
                        el.classList.add('search-highlight');
                        const offset = el.getBoundingClientRect().top + window.pageYOffset - document.querySelector(
                            '.navbar').offsetHeight;
                        window.scrollTo({
                            top: offset,
                            behavior: 'smooth'
                        });
                        found = true;
                        break;
                    }
                }

                if (!found) alert('No results found for: "' + searchTerm + '"');
                overlay.style.display = 'none';
            }
        });
    </script>

    <!-- Back to top button -->
    <button id="btnTop" class="btn-top" aria-label="Go to top">▲</button>
    <script>
        const btnTop = document.getElementById('btnTop');
        window.addEventListener('scroll', () => {
            btnTop.style.display = window.scrollY > 400 ? 'block' : 'none';
        });
        btnTop.addEventListener('click', () => {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // ===== FUNCIÓN PARA SCROLL PRECISO =====
            function scrollToSection(sectionId) {
                const targetElement = document.getElementById(sectionId);
                if (targetElement) {
                    const elementPosition = targetElement.getBoundingClientRect().top + window.pageYOffset;
                    const navbarHeight = document.querySelector('.navbar').offsetHeight;
                    const offsetPosition = elementPosition - navbarHeight;

                    window.scrollTo({
                        top: offsetPosition,
                        behavior: 'smooth'
                    });
                }
            }

            // ===== MANEJAR TÍTULOS PRINCIPALES DEL MENÚ =====
            document.querySelectorAll('.nav-link.dropdown-toggle').forEach(navLink => {
                navLink.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');

                    if (href && href.includes('#')) {
                        e.preventDefault();
                        const targetId = href.split('#')[1];
                        scrollToSection(targetId);

                        // Cerrar otros dropdowns abiertos
                        document.querySelectorAll('.dropdown-menu').forEach(menu => {
                            if (menu.classList.contains('show')) {
                                const dropdownToggle = document.querySelector(
                                    '[data-bs-target="#' + menu.parentElement.id + '"]');
                                if (dropdownToggle) {
                                    bootstrap.Dropdown.getInstance(dropdownToggle).hide();
                                }
                            }
                        });
                    }
                });
            });

            // ===== MANEJAR SUBÍTEMS DEL MENÚ =====
            document.querySelectorAll('.dropdown-item').forEach(item => {
                item.addEventListener('click', function() {
                    // Cerrar el dropdown
                    const dropdown = this.closest('.dropdown-menu');
                    const dropdownToggle = document.querySelector('[data-bs-target="#' + dropdown
                        .parentElement.id + '"]');
                    if (dropdownToggle) {
                        bootstrap.Dropdown.getInstance(dropdownToggle).hide();
                    }

                    // Scroll a la sección
                    const href = this.getAttribute('href');
                    if (href && href.includes('#')) {
                        const targetId = href.split('#')[1];
                        scrollToSection(targetId);
                    }
                });
            });

            // ===== CÓDIGO ORIGINAL DE NAVEGACIÓN MÓVIL =====
            const navbar = document.getElementById('navbarNav');
            const toggler = document.querySelector('.navbar-toggler');
            const bsCollapse = new bootstrap.Collapse(navbar, {
                toggle: false
            });

            const closeMenu = () => {
                if (window.innerWidth < 992) bsCollapse.hide();
            };

            document.querySelectorAll('.nav-link:not(.dropdown-toggle), .dropdown-item').forEach(item => {
                item.addEventListener('click', () => setTimeout(closeMenu, 100));
            });

            document.addEventListener('click', (e) => {
                if (window.innerWidth < 992 && navbar.classList.contains('show')) {
                    const isClickInsideNavbar = e.target.closest('.navbar');
                    const isClickOnToggler = e.target.closest('.navbar-toggler');
                    if (!isClickInsideNavbar && !isClickOnToggler) closeMenu();
                }
            });

            let scrollTimeout;
            window.addEventListener('scroll', () => {
                if (window.innerWidth < 992 && navbar.classList.contains('show')) {
                    clearTimeout(scrollTimeout);
                    scrollTimeout = setTimeout(closeMenu, 150);
                }
            });

            document.querySelectorAll('a.nav-link[href^="#"]').forEach(link => {
                link.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (href !== '#' && href !== '') {
                        e.preventDefault();
                        const target = document.getElementById(href.substring(1));
                        if (target) {
                            const offset = target.getBoundingClientRect().top + window.pageYOffset -
                                document.querySelector('.navbar').offsetHeight;
                            window.scrollTo({
                                top: offset,
                                behavior: 'smooth'
                            });
                            closeMenu();
                        }
                    }
                });
            });

            // ===== MANEJAR URLS CON HASH AL CARGAR =====
            if (window.location.hash) {
                const targetId = window.location.hash.substring(1);
                setTimeout(() => scrollToSection(targetId), 500);
            }
        });
    </script>
<!-- Script para que los dropdown toggles solo desplieguen submenú en móviles -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Función para detectar dispositivos móviles
    function isMobileDevice() {
        return window.innerWidth < 992; // Bootstrap lg breakpoint
    }
    
    // Seleccionar todos los dropdown toggles principales
    const dropdownToggles = document.querySelectorAll('.nav-link.dropdown-toggle');
    
    dropdownToggles.forEach(toggle => {
        // Guardar el evento click original de Bootstrap
        const originalClick = toggle.onclick;
        
        // Reemplazar el comportamiento solo en móviles
        toggle.onclick = function(e) {
            if (isMobileDevice()) {
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                
                // Alternar el dropdown manualmente
                const dropdown = new bootstrap.Dropdown(toggle);
                dropdown.toggle();
                
                return false; // Prevenir cualquier acción adicional
            }
            
            // En desktop, mantener comportamiento original
            if (originalClick) {
                return originalClick.apply(this, arguments);
            }
        };
    });
    
    // También prevenir el comportamiento en eventos touch para móviles
    dropdownToggles.forEach(toggle => {
        toggle.addEventListener('touchstart', function(e) {
            if (isMobileDevice()) {
                e.preventDefault();
                e.stopPropagation();
                
                const dropdown = new bootstrap.Dropdown(toggle);
                dropdown.toggle();
            }
        }, { passive: false });
    });
});
</script>
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <!-- AOS Init -->
    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 800,
            once: true,
            offset: 0
        });
    </script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\Proyecto_Apolo_USA\resources\views/layouts/layout.blade.php ENDPATH**/ ?>