<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Contact Message - MEYPAR USA</title>
    <style>
        body,
        table,
        td,
        div,
        p,
        a {
            margin: 0;
            padding: 0;
            border: 0;
            font-size: 100%;
            font: inherit;
            vertical-align: baseline;
            line-height: 1.6;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333333;
            background-color: #f7f7f7;
            padding: 20px 0;
            margin: 0;
        }

        .email-container {
            max-width: 650px;
            width: 100%;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        }

        .email-header {
            background: #8e2038;
            padding: 30px 20px;
            text-align: center;
            color: white;
        }

        .email-header h1 {
            font-size: 28px;
            font-weight: 700;
            margin: 15px 0 10px;
            letter-spacing: 0.5px;
        }

        .email-header p {
            font-size: 16px;
            opacity: 0.9;
            max-width: 500px;
            margin: 0 auto;
        }

        .email-content {
            padding: 35px 40px;
        }

        .section-title {
            color: #8e2038;
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
        }

        .info-grid {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 15px;
            margin-bottom: 25px;
        }

        .info-label {
            font-weight: 600;
            color: #555555;
        }

        .info-value {
            font-weight: 500;
            color: #333333;
        }

        .comments-section {
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            margin-top: 20px;
            border-left: 4px solid #05964a;
        }

        .comments-section p {
            line-height: 1.7;
            font-size: 16px;
            white-space: pre-wrap;
        }

        .email-footer {
            background: #2c2c2c;
            color: #ffffff;
            text-align: center;
            padding: 30px 20px;
            font-size: 14px;
            border-top: 1px solid #444;
        }

        .footer-notice {
            font-size: 12px;
            color: #999;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #444;
        }

        @media screen and (max-width: 600px) {
            .email-content {
                padding: 25px 20px;
            }

            .info-grid {
                grid-template-columns: 1fr;
                gap: 8px;
            }

            .email-header h1 {
                font-size: 24px;
            }
        }

        .footer-cell {
            padding: 20px 10px;
            background-color: #2c2c2c;
            color: #ffffff;
            text-align: center;
            font-size: 14px;
        }
    </style>
</head>

<body>
    <table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#f7f7f7">
        <tr>
            <td align="center" style="padding: 20px 0;">
                
                <table class="email-container" width="650" cellpadding="0" cellspacing="0" border="0"
                    bgcolor="#ffffff">
                    
                    <tr>
                        <td class="email-header" align="center"
                            style="background: #8e2038; padding: 30px 20px; color: white;">
                            <h1 style="font-size: 28px; font-weight: 700; margin: 15px 0 10px; letter-spacing: 0.5px;">
                                New Contact Message
                            </h1>
                            <p style="font-size: 16px; opacity: 0.9; max-width: 500px; margin: 0 auto;">
                                You have received a new message through the contact form
                            </p>
                        </td>
                    </tr>

                    <!-- Main Content -->
                    <tr>
                        <td class="email-content" style="padding: 35px 40px;">
                            <h2 class="section-title"
                                style="color: #8e2038; font-size: 20px; font-weight: 600; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                                Contact Information
                            </h2>

                            <table class="info-grid" width="100%">
                                <tr>
                                    <td class="info-label"
                                        style="font-weight: 600; color: #555555; padding-bottom: 10px;">
                                        Full name:
                                    </td>
                                    <td class="info-value"
                                        style="font-weight: 500; color: #333333; padding-bottom: 10px;">
                                        <?php echo e($data['name']); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td class="info-label"
                                        style="font-weight: 600; color: #555555; padding-bottom: 10px;">
                                        Phone:
                                    </td>
                                    <td class="info-value"
                                        style="font-weight: 500; color: #333333; padding-bottom: 10px;">
                                        <?php echo e($data['phone']); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td class="info-label"
                                        style="font-weight: 600; color: #555555; padding-bottom: 10px;">
                                        Email:
                                    </td>
                                    <td class="info-value"
                                        style="font-weight: 500; color: #333333; padding-bottom: 10px;">
                                        <?php echo e($data['email']); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td class="info-label"
                                        style="font-weight: 600; color: #555555; padding-bottom: 10px;">
                                        Date and time:
                                    </td>
                                    <td class="info-value"
                                        style="font-weight: 500; color: #333333; padding-bottom: 10px;">
                                        <?php echo e($data['fecha_hora']); ?>

                                    </td>
                                </tr>
                            </table>

                            <h2 class="section-title"
                                style="color: #8e2038; font-size: 20px; font-weight: 600; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                                Message
                            </h2>
                            <div class="comments-section"
                                style="background-color: #f9f9f9; padding: 20px; border-radius: 8px; margin-top: 20px; border-left: 4px solid #05964a;">
                                <p style="line-height: 1.7; font-size: 16px; white-space: pre-wrap;">
                                    <?php echo nl2br(e($data['comments'])); ?>

                                </p>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="footer-cell"
                            style="padding: 30px 20px; background-color: #2c2c2c; color: #ffffff; text-align: center; font-size: 14px;">
                            <p class="footer-text"
                                style="margin-bottom: 15px; font-size: 14px; color: #ccc; line-height: 1.5;">
                                This message was generated automatically. Please do not reply to this email.
                            </p>
                            <p class="footer-notice"
                                style="font-size: 12px; color: #999; margin-top: 20px; padding-top: 15px; border-top: 1px solid #444;">
                                © <?php echo e(date('Y')); ?> MEYPAR USA - All rights reserved
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>

</html><?php /**PATH C:\xampp\htdocs\Proyecto_Apolo_USA\resources\views/emails/contact.blade.php ENDPATH**/ ?>