<section id="contact" class="info-section mt-5 mb-5" data-aos="fade-up">
    <div class="container">
        <h2 class="text-center mb-4">Contact</h2>
        <p class="text-center">For more information, contact us by completing the following form.</p>

        <div class="row justify-content-center">
            <div class="col-md-8">
                <form id="contactForm" action="{{ route('contact.process') }}" method="POST">
                    @csrf
                    <div class="mb-3">
                        <label for="name" class="form-label">Full Name *</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name"
                            name="name" value="{{ old('name') }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">Phone *</label>
                            <input type="tel" class="form-control @error('phone') is-invalid @enderror"
                                id="phone" name="phone" value="{{ old('phone') }}" required>
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email *</label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror"
                                id="email" name="email" value="{{ old('email') }}" required>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="comments" class="form-label">Description / Comments *</label>
                        <textarea class="form-control @error('comments') is-invalid @enderror" id="comments" name="comments" rows="4"
                            required>{{ old('comments') }}</textarea>
                        @error('comments')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                        @error('g-recaptcha-response')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="text-center">
                        <button type="submit" class="btn btn-dark">Send Message</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Message Modal -->
<div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #8e2038; color: white;">
                <h5 class="modal-title" id="messageModalLabel">
                    @if (session('success'))
                        ¡Message Sent!
                    @elseif(session('warning'))
                        Important Notice
                    @elseif(session('error'))
                        Sending Error
                    @endif
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                @if (session('success'))
                    <div class="text-center">
                        <i class="bi bi-check-circle-fill text-success" style="font-size: 3rem;"></i>
                        <p class="fs-5 mt-3">{{ session('success') }}</p>
                    </div>
                @endif
                @if (session('warning'))
                    <div class="text-center">
                        <i class="bi bi-exclamation-triangle-fill text-warning" style="font-size: 3rem;"></i>
                        <p class="fs-5 mt-3">{{ session('warning') }}</p>
                    </div>
                @endif
                @if (session('error'))
                    <div class="text-center">
                        <i class="bi bi-x-circle-fill text-danger" style="font-size: 3rem;"></i>
                        <p class="fs-5 mt-3">{{ session('error') }}</p>
                    </div>
                @endif
            </div>
            <div class="modal-footer border-0 justify-content-center" style="background-color: #f7f7f7;">
                <button type="button" class="btn"
                    style="background-color: #05964a; color: white; padding: 8px 30px; border-radius: 30px;"
                    data-bs-dismiss="modal">
                    Accept
                </button>
            </div>
        </div>
    </div>
</div>

@if (session('success') || session('warning') || session('error'))
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var messageModal = new bootstrap.Modal(document.getElementById('messageModal'));
            messageModal.show();

            @if ($errors->has('g-recaptcha-response'))
                document.getElementById('contactForm').addEventListener('shown.bs.modal', function() {
                    grecaptcha.reset();
                });
            @endif
        });
    </script>
@endif
