@extends('layouts.layout')

@section('title', 'Job Bank')

@push('styles')
    <link rel="stylesheet" href="{{ asset('css/bolsa.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .invalid-feedback {
            display: none;
            width: 100%;
            margin-top: 0.25rem;
            font-size: 0.875em;
            color: #dc3545;
        }

        .was-validated .form-control:invalid~.invalid-feedback,
        .was-validated .form-control:invalid~.invalid-feedback,
        .was-validated .form-select:invalid~.invalid-feedback {
            display: block;
        }

        .form-check {
            margin-bottom: 0.5rem;
        }
    </style>
@endpush

@section('content')
    <section class="py-5 bg-light">
        <div class="bolsa-container">
            <h1 class="bolsa-title">Job Bank</h1>
            <p class="lead text-center mb-5">
                <i class="fas fa-handshake me-2" style="color: #8e2038;"></i>
                Thank you for your interest in joining <strong>EYSPSA</strong>. We're always looking for 
                talent. If you meet the following requirements, apply now!
            </p>

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <form action="{{ route('job-bank.submit') }}" method="POST" class="row g-4 needs-validation" novalidate>
                @csrf

                <!-- General Information -->
                <h2 class="bolsa-subtitle"><i class="fas fa-user-circle me-2"></i>General Information</h2>

                <div class="col-md-6">
                    <label for="name" class="form-label">Full Name</label>
                    <input type="text" id="name" name="name" class="form-control"
                        placeholder="Ex. John Doe" required>
                    <div class="invalid-feedback">
                        Please enter your full name
                    </div>
                </div>

                <div class="col-md-3">
                    <label for="whatsapp" class="form-label">WhatsApp</label>
                    <input type="tel" id="whatsapp" name="whatsapp" pattern="[0-9]{10}" class="form-control"
                        placeholder="Ex. 5512345678" required>
                    <div class="invalid-feedback">
                        10-digit number without spaces or dashes
                    </div>
                </div>

                <div class="col-md-3">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" id="email" name="email" class="form-control"
                        placeholder="Ex. example@gmail.com" required>
                    <div class="invalid-feedback">
                        Please enter a valid email
                    </div>
                </div>

                <div class="col-12">
                    <label class="form-label d-block">Gender</label>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="gender" id="gender_m" value="Male"
                            required>
                        <label class="form-check-label" for="gender_m"><i class="fas fa-male me-1"></i> Male</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="gender" id="gender_f" value="Female"
                            required>
                        <label class="form-check-label" for="gender_f"><i class="fas fa-female me-1"></i> Female</label>
                    </div>
                </div>

                <!-- Studies -->
                <h2 class="bolsa-subtitle"><i class="fas fa-graduation-cap me-2"></i>Education & Specialized Studies</h2>
                <div class="col-12">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="prepa" name="studies[]"
                            value="High School">
                        <label class="form-check-label" for="prepa"><i
                                class="fas fa-school me-2"></i>High School</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="tecnica" name="studies[]"
                            value="Technical Degree">
                        <label class="form-check-label" for="tecnica"><i class="fas fa-laptop-code me-2"></i>Technical Degree (Systems, Electronics, Computing or related)</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="lic" name="studies[]"
                            value="Bachelor's Degree">
                        <label class="form-check-label" for="lic"><i
                                class="fas fa-user-graduate me-2"></i>Bachelor's Degree</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="pos" name="studies[]"
                            value="Postgraduate">
                        <label class="form-check-label" for="pos"><i
                                class="fas fa-book-open me-2"></i>Postgraduate</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <label for="degree_obtained" class="form-label">Degree Obtained (if applicable)</label>
                    <input type="text" id="degree_obtained" name="degree_obtained" class="form-control"
                        placeholder="Ex. Computer Systems Engineer">
                </div>

                <!-- Skills -->
                <h2 class="bolsa-subtitle"><i class="fas fa-tools me-2"></i>Skills</h2>

                <div class="col-12">
                    <p class="mb-1"><i class="fas fa-wrench me-2"></i>Tools you can handle safely:</p>
                    <div class="row">
                        @php
                            $tools = ['Screwdrivers', 'Pliers', 'Soldering Iron', 'Multimeter'];
                        @endphp
                        @foreach ($tools as $t)
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="tools[]"
                                        id="tool_{{ $t }}" value="{{ $t }}">
                                    <label class="form-check-label" for="tool_{{ $t }}"><i
                                            class="fas fa-check-circle me-1"></i>{{ $t }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="col-12 mt-3">
                    <p class="mb-1"><i class="fas fa-laptop me-2"></i>Basic Computing Skills:</p>
                    <div class="row">
                        @php
                            $computo = ['Windows', 'Office', 'Networks', 'Electronics'];
                        @endphp
                        @foreach ($computo as $c)
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="computer_skills[]"
                                        id="comp_{{ $c }}" value="{{ $c }}">
                                    <label class="form-check-label" for="comp_{{ $c }}"><i
                                            class="fas fa-check-circle me-1"></i>{{ $c }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="col-12 mt-3">
                    <p class="mb-1"><i class="fas fa-comments me-2"></i>Soft Skills:</p>
                    <div class="row">
                        @php
                            $soft = [
                                'Customer Service',
                                'Conflict Resolution',
                                'Frustration Tolerance',
                                'Crisis Management',
                            ];
                        @endphp
                        @foreach ($soft as $s)
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="soft_skills[]"
                                        id="soft_{{ $loop->index }}" value="{{ $s }}">
                                    <label class="form-check-label" for="soft_{{ $loop->index }}"><i
                                            class="fas fa-check-circle me-1"></i>{{ $s }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Work Zone -->
                <h2 class="bolsa-subtitle"><i class="fas fa-map-marker-alt me-2"></i>Work Zone of Interest</h2>
                <div class="col-md-6">
                    <select name="zone" id="zone" class="form-select" required>
                        <option value="" selected disabled>Select a zone</option>
                        @php
                            $zonas = [
                                'Aguascalientes',
                                'CDMX',
                                'Jalisco',
                                'Monterrey',
                                'Queretaro',
                                'Quintana Roo',
                                'San Luis Potosí',
                                'Sinaloa',
                                'Tampico',
                                'Zona Metropolitana EDOMEX',
                            ];
                        @endphp
                        @foreach ($zonas as $z)
                            <option value="{{ $z }}">{{ $z }}</option>
                        @endforeach
                    </select>
                    <div class="invalid-feedback">
                        Please select a work zone
                    </div>
                </div>

                <!-- Submit -->
                <div class="col-12 text-center mt-4">
                    <button type="submit" class="btn-submit">
                        <i class="fas fa-paper-plane me-2"></i>Submit Application
                    </button>
                </div>
            </form>
        </div>
    </section>
@endsection

@push('scripts')
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>

    <script>
        (() => {
            'use strict'
            const forms = document.querySelectorAll('.needs-validation')
            Array.from(forms).forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }
                    form.classList.add('was-validated')
                }, false)
            })
        })()
    </script>
@endpush