<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitud de Bolsa de Trabajo - EYSPSA</title>
    <style>
        body, table, td, div, p, a {
            margin: 0;
            padding: 0;
            border: 0;
            font-size: 100%;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333333;
        }
        
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .email-header {
            background: #8e2038;
            padding: 25px;
            text-align: center;
            color: white;
        }
        
        .email-header h1 {
            font-size: 24px;
            font-weight: 700;
            margin: 10px 0;
        }
        
        .email-content {
            padding: 30px;
        }
        
        .section-title {
            color: #8e2038;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 12px;
            margin-bottom: 20px;
        }
        
        .info-label {
            font-weight: 600;
            color: #555555;
        }
        
        .info-value {
            font-weight: 500;
            color: #333333;
        }
        
        .list-section {
            background-color: #f9f9f9;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
            border-left: 4px solid #05964a;
        }
        
        .list-title {
            font-weight: 600;
            margin-bottom: 8px;
            color: #8e2038;
        }
        
        .list-item {
            margin-bottom: 5px;
            padding-left: 15px;
            position: relative;
        }
        
        .list-item:before {
            content: "•";
            position: absolute;
            left: 0;
            color: #05964a;
        }
        
        .email-footer {
            background: #2c2c2c;
            color: #ffffff;
            text-align: center;
            padding: 20px;
            font-size: 12px;
            border-top: 1px solid #444;
        }
        
        .footer-text {
            margin-bottom: 10px;
            color: #ccc;
            line-height: 1.5;
        }
        
        .footer-notice {
            font-size: 11px;
            color: #999;
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px solid #444;
        }
        
        @media screen and (max-width: 600px) {
            .email-content {
                padding: 20px;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
                gap: 8px;
            }
        }
    </style>
</head>
<body style="background-color: #f7f7f7; padding: 20px 0;">
    <div class="email-container">
        <!-- Cabecera -->
        <div class="email-header">
            <h1>Nueva Solicitud de Bolsa de Trabajo</h1>
            <p>Sistema de Bolsa de Trabajo EYSPSA</p>
        </div>
        
        <!-- Contenido principal -->
        <div class="email-content">
            <h2 class="section-title">Información del Candidato</h2>
            
            <div class="info-grid">
                <div class="info-label">Nombre completo:</div>
                <div class="info-value">{{ $datos['nombre'] }}</div>
                
                <div class="info-label">WhatsApp:</div>
                <div class="info-value">{{ $datos['whatsapp'] }}</div>
                
                <div class="info-label">Correo electrónico:</div>
                <div class="info-value">{{ $datos['correo'] }}</div>
                
                <div class="info-label">Sexo:</div>
                <div class="info-value">{{ $datos['sexo'] }}</div>
                
                <div class="info-label">Zona de interés:</div>
                <div class="info-value">{{ $datos['zona'] }}</div>
            </div>
            
            <!-- Estudios -->
            <h2 class="section-title">Estudios</h2>
            <div class="list-section">
                <div class="list-title">Nivel de estudios:</div>
                @foreach($datos['estudios'] as $estudio)
                    <div class="list-item">{{ $estudio }}</div>
                @endforeach
                
                <div class="list-title" style="margin-top: 12px;">Título obtenido:</div>
                <div>{{ $datos['titulo_obtenido'] }}</div>
            </div>
            
            <!-- Herramientas -->
            <h2 class="section-title">Herramientas</h2>
            <div class="list-section">
                @foreach($datos['herramientas'] as $herramienta)
                    <div class="list-item">{{ $herramienta }}</div>
                @endforeach
            </div>
            
            <!-- Computación -->
            <h2 class="section-title">Computación</h2>
            <div class="list-section">
                @foreach($datos['computacion'] as $computacion)
                    <div class="list-item">{{ $computacion }}</div>
                @endforeach
            </div>
            
            <!-- Habilidades Blandas -->
            <h2 class="section-title">Habilidades Blandas</h2>
            <div class="list-section">
                @foreach($datos['blandas'] as $blanda)
                    <div class="list-item">{{ $blanda }}</div>
                @endforeach
            </div>
        </div>
        
        <!-- Pie de página -->
        <div class="email-footer">
            <div class="footer-text">
                Solicitud recibida el {{ now()->format('d/m/Y H:i') }} | Sistema de Bolsa de Trabajo EYSPSA
            </div>
            <div class="footer-text">
                Este mensaje fue generado automáticamente. Por favor no responda a este correo.
            </div>
            <div class="footer-notice">
                © {{ date('Y') }} EYSPSA - Todos los derechos reservados
            </div>
        </div>
    </div>
</body>
</html>