document.addEventListener('DOMContentLoaded', function() {
    const html = document.documentElement;
    let scrollPos = 0;

    // Abrir modal con scroll automático
    document.querySelectorAll('[data-modal]').forEach(button => {
        button.addEventListener('click', function() {
            const modalId = this.getAttribute('data-modal');
            const modal = document.getElementById(modalId);
            if (modal) {
                scrollPos = window.pageYOffset;
                modal.classList.add('open');
                html.classList.add('ez-lock');
                
                // Auto-scroll para todos los dispositivos
                setTimeout(() => {
                    const blockPosition = window.innerWidth <= 767.98 ? 'start' : 'center';
                    modal.scrollIntoView({
                        behavior: 'smooth',
                        block: blockPosition,
                        inline: 'nearest'
                    });
                }, 100);
            }
        });
    });

    // Cerrar modal al hacer clic en el botón de cerrar o en el fondo
    document.querySelectorAll('.ez-close, .ez-modal').forEach(element => {
        element.addEventListener('click', function(e) {
            if (e.target.classList.contains('ez-close') || e.target === this) {
                const modal = e.target.closest('.ez-modal');
                if (modal) {
                    modal.classList.remove('open');
                    html.classList.remove('ez-lock');
                    window.scrollTo(0, scrollPos);
                }
            }
        });
    });

    // Cerrar con tecla Escape
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            const openModal = document.querySelector('.ez-modal.open');
            if (openModal) {
                openModal.classList.remove('open');
                html.classList.remove('ez-lock');
                window.scrollTo(0, scrollPos);
            }
        }
    });
});