<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_bank', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('whatsapp');
            $table->string('email');
            $table->enum('gender', ['Male', 'Female']);
            $table->json('studies')->nullable();
            $table->string('degree_obtained')->nullable();
            $table->json('tools')->nullable();
            $table->json('computer_skills')->nullable();
            $table->json('soft_skills')->nullable();
            $table->string('zone');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('job_bank');
    }
};
