<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobBank extends Model
{
    use HasFactory;

    // Nombre de tabla actualizado
    protected $table = 'job_bank';
    
    // Campos actualizados
    protected $fillable = [
        'name', 'whatsapp', 'email', 'gender', 
        'studies', 'degree_obtained', 'tools', 
        'computer_skills', 'soft_skills', 'zone'
    ];
    
    // Casts actualizados
    protected $casts = [
        'studies' => 'array',
        'tools' => 'array',
        'computer_skills' => 'array',
        'soft_skills' => 'array'
    ];
}