<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class JobBankMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function build()
    {
        return $this->from(env('MAIL_FROM_ADDRESS'), 'EYSPSA Job Bank') 
                    ->subject('New Job Bank Application - EYSPSA')
                    ->view('emails.job_bank') // Vista actualizada
                    ->with('data', $this->data);
    }
}