<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\JobBankMail; 
use App\Models\JobBank; 

class JobBankController extends Controller 
{
    public function showForm()
    {
        return view('job_bank'); 
    }

    public function processForm(Request $request) 
    {
        $request->validate([
            'name' => 'required|string|max:255', 
            'whatsapp' => 'required|string|max:10',
            'email' => 'required|email|max:255', 
            'gender' => 'required|in:Male,Female', 
            'zone' => 'required|string', 
            //'g-recaptcha-response' => 'required|recaptcha'
        ]);

        $data = [
            'name' => $request->name,
            'whatsapp' => $request->whatsapp,
            'email' => $request->email,
            'gender' => $request->gender,
            'studies' => $request->input('studies', []), 
            'degree_obtained' => $request->degree_obtained, 
            'tools' => $request->input('tools', []), 
            'computer_skills' => $request->input('computer_skills', []), 
            'soft_skills' => $request->input('soft_skills', []), 
            'zone' => $request->zone
        ];

        try {
            JobBank::create($data); 
        } catch (\Exception $e) {
            return back()->with('error', 'Error saving to database: '.$e->getMessage());
        }

        $recipients = [
            'fvaldovinos@eyspsa.com',
            'aramirez@eyspsa.com', 
        ];

        try {
            Mail::to($recipients)->send(new JobBankMail($data)); 
            return back()->with('success', 'Thanks for your application! We will contact you soon.');
        } catch (\Exception $e) {
            return back()->with('error', 'Error sending your application: '.$e->getMessage());
        }
    }
}